#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'

describe '[Story# VAR-1752: Landing Page - Booked Appointments View]
          [Story# VAR-2339: Update Landing Page and related Menu]
          [Story# VAR-3613: Landing PAge - Appointment List - Add Facility]
          [STORY# VAR-11872: Appointment List: VA Facility Appointment – update format]'  do
  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @app_menu = AppOptionsMenu.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    APPOINTMENTS = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y @ 09:00")
    @twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y @ 09:00")
    @sevenDaysLater = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @thirtyDaysLater = getDateNthDaysFromNow(30, "%m/%d/%Y @ 09:00")
    @thirtyOneDaysLater = getDateNthDaysFromNow(31, "%m/%d/%Y @ 09:00")
    #cancel existing appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysLater} 10:00:00")
    @cancel_appointment.cancel_appointment()
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
    @@timeSlot = "10:00"
    @friendly_name = "Facility Friendly Text"
    @clinic_friendly_name ="JP PRIMARY CARE DR. CREAMER"
    @location = "BOSTON HCS VAMC"
    @clinic = PRIMARY_CARE.upcase.strip
  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-1807|TC#VAR-1936: Landing Page - Booked Appointment View Criteria]
           [AC#VAR-2761|TC#VAR-2764: Update Landing Page and related menu criteria]
           [AC#VAR-3706|TC#VAR-3705: Landing Page - add facility criteria]
           [AC#VAR-11993|TC#VAR-11994: Appointment List: VA Facility Appointment – update format]'  do
    it "Section/table title: Appointments" do

      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)
      expect(@landing_appointments.appointment_header).to eq("Appointments")

    end

    it "Column 1 - Date/Time" do
      @common.selectAddAppointmentButton("VA")
      @@cc_enabled = @common.ccEnabled
      @new_appointment.createAppointment(PRIMARY_CARE, '523', '32', 'test', @sevenDaysLater, @@timeSlot, 'testAutomation@testAutomationxyz.com')
      @@setDate = NewAppointmentRequest.bookedDate
      @@selectedSlot = @@setDate
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.refresh
      @common.waitWhileSpinnerPresent
      sleep 2
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >= 1}
      expect(@landing_appointments.getNthAppointmentTableHeader(1)).to eq("Date/Time")

    end

    it "Column 2 - Details" do
      expect(@landing_appointments.getNthAppointmentTableHeader(2)).to eq("Details")
    end

    it "Column 3 - Prepair/Join" do
      expect(@landing_appointments.getNthAppointmentTableHeader(3)).to eq("Prepare/Join")

    end

    it "Column 4 - Display a > icon " do
      expect(@landing_appointments.first_appointment_element.attribute('class')).to include("ui-btn-icon-right")
      expect(@landing_appointments.appointment_table_list_elements[1].text).to include("View details for your appointment,\nDate/Time:\n")
    end

    it "should verify appointment list loads with minified version of code" do
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      @@selectedDay = getDayofWeek(@@selectedSlot)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_verify = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate}" + "\n" + "#{@@timeSlot}" + "\n" + "#{@@selectedDay}, #{@@setDate} #{@@timeSlot.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@location}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      expect(@landing_appointments.verifyAppointmentDetailsInList(all_appointments, appointment_to_verify)).to eq(true)
    end
  end
end











